<?php
class BWGViewImage_browser {
  public function display($params = array(), $from_shortcode = 0, $bwg = 0) {
    require_once(BWG()->plugin_dir . '/framework/WDWLibrary.php');
    require_once(BWG()->plugin_dir . '/framework/WDWLibraryEmbed.php');

    $order_by = $params['order_by'];
    $image_title = $params['image_browser_title_enable'];
    $enable_image_description = $params['image_browser_description_enable'];
    $image_right_click = isset(BWG()->options->image_right_click) ? BWG()->options->image_right_click : 0;
    $placeholder = $params['placeholder'];
    $gallery_download = $params['gallery_download'];

    $theme_row = WDWLibrary::get_theme_row_data($params['theme_id']);
    if (!$theme_row) {
      echo WDWLibrary::message(__('There is no theme selected or the theme was deleted.', BWG()->prefix), 'wd_error');
      return;
    }
    $gallery_row = WDWLibrary::get_gallery_row_data($params['gallery_id']);
    if (!$gallery_row && $params["tag"] == 0) {
      echo WDWLibrary::message(__('There is no gallery selected or the gallery was deleted.', BWG()->prefix), 'wd_error');
      return;
    }
    $image_rows = WDWLibrary::get_image_rows_data($params['gallery_id'], $bwg, 'image_browser', '', $params['tag'], 1, 1, $params['sort_by'], $params['order_by']);
    $page_nav = $image_rows['page_nav'];
    $image_rows = $image_rows['images'];
    $images_count = count($image_rows);
    if (!$image_rows) {
      if ($params['tag']) {
        echo WDWLibrary::message(__('There are no images.', BWG()->prefix), 'wd_error');
      }
      else {
        echo WDWLibrary::message(__('There are no images in this gallery.', BWG()->prefix), 'wd_error');
      }
    }

    $params_array = array(
      'action' => 'GalleryBox',
      'current_view' => $bwg,
      'gallery_id' => $params['gallery_id'],
      'theme_id' => $params['theme_id'],
      'open_with_fullscreen' => $params['popup_fullscreen'],
      'open_with_autoplay' => $params['popup_autoplay'],
      'image_width' => $params['popup_width'],
      'image_height' => $params['popup_height'],
      'image_effect' => $params['popup_effect'],
      'wd_sor' => $params['sort_by'],
      'wd_ord' => $order_by,
      'enable_image_filmstrip' => $params['popup_enable_filmstrip'],
      'image_filmstrip_height' => $params['popup_filmstrip_height'],
      'enable_image_ctrl_btn' => $params['popup_enable_ctrl_btn'],
      'enable_image_fullscreen' => $params['popup_enable_fullscreen'],
      'popup_enable_info' => $params['popup_enable_info'],
      'popup_info_always_show' => $params['popup_info_always_show'],
      'popup_info_full_width' => $params['popup_info_full_width'],
      'popup_hit_counter' => $params['popup_hit_counter'],
      'popup_enable_rate' => $params['popup_enable_rate'],
      'slideshow_interval' => $params['popup_interval'],
      'enable_comment_social' => $params['popup_enable_comment'],
      'enable_image_facebook' => $params['popup_enable_facebook'],
      'enable_image_twitter' => $params['popup_enable_twitter'],
      'enable_image_google' => $params['popup_enable_google'],
      'enable_image_pinterest' => $params['popup_enable_pinterest'],
      'enable_image_tumblr' => $params['popup_enable_tumblr'],
      'watermark_type' => $params['watermark_type'],
      'slideshow_effect_duration' => isset($params['popup_effect_duration']) ? $params['popup_effect_duration'] : 1,
      'tags' => (isset($params['tag']) ? $params['tag'] : 0),
      'popup_enable_email' => $params['popup_enable_email'],
      'popup_enable_captcha' => $params['popup_enable_captcha'],
      'comment_moderation' => $params['comment_moderation'],
      'autohide_lightbox_navigation' => $params['autohide_lightbox_navigation'],
      'popup_enable_fullsize_image' => $params['popup_enable_fullsize_image'],
      'popup_enable_download' => $params['popup_enable_download'],
      'show_image_counts' => $params['show_image_counts'],
      'enable_loop' => $params['enable_loop'],
      'enable_addthis' => $params['enable_addthis'],
      'addthis_profile_id' => $params['addthis_profile_id']
    );
    if ( BWG()->is_pro ) {
      $current_url = (is_ssl() ? 'https://' : 'http://') . $_SERVER['HTTP_HOST'] . $_SERVER['REQUEST_URI'];
      $params_array['current_url'] = urlencode($current_url);;
      $params_array['enable_image_ecommerce'] = $params['popup_enable_ecommerce'];
    }
    $items_per_page = array('images_per_page' => 1, 'load_more_image_count' => 1);
    if ($params['watermark_type'] == 'none') {
      $params_array['watermark_font'] = '';
      $params_array['watermark_color'] = '';
      $params_array['watermark_font_size'] = '';
      $params_array['watermark_opacity'] = 0;
      $text_align = '';
      $vertical_align = '';
      $params_array['watermark_width'] = '';
      $show_watermark = FALSE;
    }
    if ($params['watermark_type'] != 'none') {
      $params_array['watermark_link'] = $params['watermark_link'];
      $params_array['watermark_opacity'] = (int) $params['watermark_opacity'];
      $params_array['watermark_position'] =(($params['watermark_position'] != 'undefined') ? $params['watermark_position'] : 'top-center');
			$position = explode('-', $params_array['watermark_position']);
			$vertical_align = $position[0];
			$text_align = $position[1];
    }
    if ($params['watermark_type'] == 'text') {
      $show_watermark = TRUE;
      $watermark_text_image = TRUE;
      $params_array['watermark_text'] = $params['watermark_text'];
      $params_array['watermark_font_size'] = $params['watermark_font_size'];
      $params_array['watermark_font'] = $params['watermark_font'];
      $params_array['watermark_color'] = $params['watermark_color'];
			$params_array['watermark_width'] = 0;
			$watermark_image_or_text = $params_array['watermark_text'];
			$watermark_a = 'bwg_watermark_text_' . $bwg;
			$watermark_div = 'class="bwg_image_browser_watermark_text_' . $bwg . '"';
    }
    elseif ($params['watermark_type'] == 'image') {
      $show_watermark = TRUE;
      $watermark_text_image = FALSE;
      $params_array['watermark_url'] = $params['watermark_url'];
      $params_array['watermark_width'] = (int) $params['watermark_width'];
      $params_array['watermark_height'] = $params['watermark_height'];
			$watermark_image_or_text = '<img class="bwg_image_browser_watermark_img_' . $bwg . '" src="' . urldecode($params_array['watermark_url']) . '" />';
			$watermark_a = '';
			$watermark_div = 'class="bwg_image_browser_watermark_' . $bwg . '"';
      $params_array['watermark_font'] = '';
      $params_array['watermark_color'] = '';
       $params_array['watermark_font_size'] = ''; 
    }
    $image_browser_image_title_align = (isset($theme_row->image_browser_image_title_align)) ? $theme_row->image_browser_image_title_align : 'top';
     if (!isset($theme_row->image_browser_gal_title_font_color)) {
        $theme_row->image_browser_gal_title_font_color = 'CCCCCC';
      }
      if (!isset($theme_row->image_browser_gal_title_font_style)) {
        $theme_row->image_browser_gal_title_font_style = 'segoe ui';
      }
      if (!isset($theme_row->image_browser_gal_title_font_size)) {
        $theme_row->image_browser_gal_title_font_size = 16;
      }
      if (!isset($theme_row->image_browser_gal_title_font_weight)) {
        $theme_row->image_browser_gal_title_font_weight = 'bold';
      }
      if (!isset($theme_row->image_browser_gal_title_margin)) {
        $theme_row->image_browser_gal_title_margin = '2px';
      }
      if (!isset($theme_row->image_browser_gal_title_shadow)) {
        $theme_row->image_browser_gal_title_shadow = '0px 0px 0px #888888';
      }
      if (!isset($theme_row->image_browser_gal_title_align)) {
        $theme_row->image_browser_gal_title_align = 'center';
      }
    $inline_style = $this->inline_styles($bwg, $theme_row, $params, $params_array, $text_align, $vertical_align);
    if (BWG()->options->use_inline_stiles_and_scripts) {
      wp_enqueue_style('bwg_frontend');
      wp_add_inline_style('bwg_frontend', $inline_style);
      wp_enqueue_style('bwg_font-awesome');
      wp_enqueue_style('bwg_mCustomScrollbar');
      wp_enqueue_style('bwg_googlefonts');
      if (!wp_script_is('bwg_frontend', 'done')) {
        wp_print_scripts('bwg_frontend');
      }
      if ($params['thumb_click_action'] == 'open_lightbox') {
        if (!wp_script_is('bwg_mCustomScrollbar', 'done')) {
          wp_print_scripts('bwg_mCustomScrollbar');
        }
        if (!wp_script_is('jquery-fullscreen', 'done')) {
          wp_print_scripts('jquery-fullscreen');
        }
        if (!wp_script_is('bwg_gallery_box', 'done')) {
          wp_print_scripts('bwg_gallery_box');
        }
        if ( BWG()->is_pro && !wp_script_is('bwg_raty', 'done')) {
          wp_print_scripts('bwg_raty');
        }
      }
      if (!wp_script_is('bwg_jquery_mobile', 'done')) {
        wp_print_scripts('bwg_jquery_mobile');
      }
    }
    else {
      echo '<style>' . $inline_style . '</style>';
    }
    ?>
    <div id="bwg_container1_<?php echo $bwg; ?>">
      <div id="bwg_container2_<?php echo $bwg; ?>">
        <form id="gal_front_form_<?php echo $bwg; ?>" method="post" action="#" data-current="<?php echo $bwg; ?>">
          <?php
          if ($params['show_search_box']) {
            WDWLibrary::ajax_html_frontend_search_box('gal_front_form_' . $bwg, $bwg, 'bwg_image_browser_' . $bwg, $images_count, $params['search_box_width'], $placeholder);
          }
          if ($params['showthumbs_name'] && $gallery_row->name != '') {
            ?>
              <div class="bwg_gal_title_<?php echo $bwg; ?>"><?php echo $gallery_row->name; ?></div>
            <?php
          }
          if ($params['show_gallery_description'] && $gallery_row->name != '') {
            ?>
              <div class="bwg_gal_title_<?php echo $bwg; ?>"><?php echo $gallery_row->description; ?></div>
            <?php
          }
          ?>
          <div class="image_browser_images_conteiner_<?php echo $bwg; ?>">
            <div id="ajax_loading_<?php echo $bwg; ?>" style="position:absolute;width: 100%; z-index: 115; text-align: center; height: 100%; vertical-align: middle; display:none;">
              <div style="display: table; vertical-align: middle; width: 100%; height: 100%; background-color: #FFFFFF; opacity: 0.7; filter: Alpha(opacity=70);">
                <div style="display: table-cell; text-align: center; position: relative; vertical-align: middle;" >
                  <div id="loading_div_<?php echo $bwg; ?>" class="bwg_spider_ajax_loading" style="display: inline-block; text-align:center; position:relative; vertical-align:middle; background-image:url(<?php echo BWG()->plugin_url . '/images/ajax_loader.png'; ?>); float: none; width:30px;height:30px;background-size:30px 30px;">
                  </div>
                </div>
              </div>
            </div>
            <div class="image_browser_images_<?php echo $bwg; ?>" id="bwg_image_browser_<?php echo $bwg; ?>" >
              <?php
              if ( $theme_row->page_nav_position == 'top') {
                WDWLibrary::ajax_html_frontend_page_nav($theme_row, $page_nav['total'], $page_nav['limit'], 'gal_front_form_' . $bwg, $items_per_page, $bwg, 'bwg_image_browser_' . $bwg, 0, 'album', BWG()->options->enable_seo);
              }
              foreach ($image_rows as $image_row) {
                $params_array['image_id'] = (isset($_POST['image_id']) ? esc_html($_POST['image_id']) : $image_row->id);
                $is_embed = preg_match('/EMBED/',$image_row->filetype)==1 ? true :false;
                $is_embed_16x9 = ((preg_match('/EMBED/',$image_row->filetype)==1 ? true : false) && (preg_match('/VIDEO/',$image_row->filetype)==1 ? true : false) && !(preg_match('/INSTAGRAM/',$image_row->filetype)==1 ? true :false));
                $is_embed_instagram_post = preg_match('/INSTAGRAM_POST/',$image_row->filetype)==1 ? true :false;
                ?>  
                <div class="image_browser_image_buttons_conteiner_<?php echo $bwg; ?>">
                  <div class="image_browser_image_buttons_<?php echo $bwg;?>">
                    <?php
                    if ($image_title && ($image_browser_image_title_align == 'top')) {
                      ?>
                    <div class="bwg_image_browser_image_alt_<?php echo $bwg; ?>">
                       <div class="bwg_image_alt_<?php echo $bwg; ?>" id="alt<?php echo $image_row->id; ?>">
                         <?php echo html_entity_decode($image_row->alt); ?>
                       </div>
                    </div> 
                      <?php
                    }
                    ?>
                    <div class="bwg_image_browser_image_<?php echo $bwg; ?>">
                      <?php
                      if ($show_watermark) {
                        ?>
                        <div class="bwg_image_browser_image_contain_<?php echo $bwg; ?>" id="bwg_image_browser_image_contain_<?php echo $image_row->id ?>">
                          <div class="bwg_image_browser_watermark_contain_<?php echo $bwg; ?>">
                            <div class="bwg_image_browser_watermark_cont_<?php echo $bwg; ?>">
                              <div <?php echo $watermark_div; ?> >
                                <a class="bwg_none_selectable <?php echo $watermark_a; ?>" id="watermark_a<?php echo $image_row->id; ?>" href="<?php echo urldecode($params_array['watermark_link']); ?>" target="_blank">
                                  <?php echo $watermark_image_or_text; ?>
                                </a>
                              </div>
                            </div>
                          </div>
                        </div>
                        <?php
                      }
                      if (!$is_embed) {
                      ?>
                        <a style="position:relative;" <?php echo ($params['thumb_click_action'] == 'open_lightbox' ? (' class="bwg_lightbox_' . $bwg . '" data-image-id="' . $image_row->id . '"') : ($params['thumb_click_action'] == 'redirect_to_url' && $image_row->redirect_url ? 'href="' . $image_row->redirect_url . '" target="' .  ($params['thumb_link_target'] ? '_blank' : '')  . '"' : '')) ?>>
                          <img class="bwg_image_browser_img_<?php echo $bwg; ?>" src="<?php echo BWG()->upload_url . $image_row->image_url; ?>" alt="<?php echo $image_row->alt; ?>" />
                        </a>
                      <?php 
                      }
                      else { /*$is_embed*/
                        if($is_embed_16x9) {
                          WDWLibraryEmbed::display_embed($image_row->filetype, $image_row->image_url, $image_row->filename, array('id' => "bwg_embed_frame_16x9_" . $bwg, 'width' => $params['image_browser_width'], 'height' => $params['image_browser_width'] * 0.5625, 'frameborder' => "0", 'allowfullscreen' => "allowfullscreen", 'style' => "position: relative; margin:0;"));          
                        }
                        else if($is_embed_instagram_post) {
                          $instagram_post_width = $params['image_browser_width'];
                          $instagram_post_height = $params['image_browser_width'];
                          $image_resolution = explode(' x ', $image_row->resolution);
                          if (is_array($image_resolution)) {
                            $instagram_post_width = $image_resolution[0];
                            $instagram_post_height = explode(' ', $image_resolution[1]);
                            $instagram_post_height = $instagram_post_height[0];
                          }
                          WDWLibraryEmbed::display_embed($image_row->filetype, $image_row->image_url, $image_row->filename, array('class' => "bwg_embed_frame_instapost_" . $bwg, 'data-width' => $instagram_post_width, 'data-height' => $instagram_post_height, 'frameborder' => "0", 'allowfullscreen' => "allowfullscreen", 'style' => "position: relative; margin:0;"));          
                        }
                        else{/*for instagram image, video and flickr enable lightbox onclick*/
                          ?>
                          <a style="position:relative;" <?php echo ($params['thumb_click_action'] == 'open_lightbox' ? (' class="bwg_lightbox_' . $bwg . '" data-image-id="' . $image_row->id . '"') : ($image_row->redirect_url ? 'href="' . $image_row->redirect_url . '" target="' .  ($params['thumb_link_target'] ? '_blank' : '')  . '"' : '')) ?>>
                            <?php
                            WDWLibraryEmbed::display_embed($image_row->filetype, $image_row->image_url, $image_row->filename, array('id'=>"bwg_embed_frame_".$bwg,'width'=>$params['image_browser_width'], 'height'=>'auto', 'frameborder'=>"0", 'allowfullscreen'=>"allowfullscreen", 'style'=>"position: relative; margin:0;"));          
                          ?>
                          </a>

                        <?php
                        } 
                      }
                      ?>
                      <script>
                      function bwg_image_browser_<?php echo $bwg; ?>() {
                        jQuery('#bwg_embed_frame_16x9_<?php echo $bwg; ?>').width(jQuery('#bwg_embed_frame_16x9_<?php echo $bwg; ?>').parent().width());
                        jQuery('#bwg_embed_frame_16x9_<?php echo $bwg; ?>').height(jQuery('#bwg_embed_frame_16x9_<?php echo $bwg; ?>').width() * 0.5625);
                        jQuery('#bwg_embed_frame_instapost_<?php echo $bwg; ?>').width(jQuery('#bwg_embed_frame_16x9_<?php echo $bwg; ?>').parent().width());
                        /* 16 is 2*padding inside iframe */
                        /* 96 is 2*padding(top) + 1*padding(bottom) + 40(footer) + 32(header) */
                        jQuery('.bwg_embed_frame_instapost_<?php echo $bwg; ?>').height((jQuery('.bwg_embed_frame_instapost_<?php echo $bwg; ?>').width() - 16) * jQuery('.bwg_embed_frame_instapost_<?php echo $bwg; ?>').attr('data-height') / jQuery('.bwg_embed_frame_instapost_<?php echo $bwg; ?>').attr('data-width') + 96);

                        var bwg_image_browser_width = jQuery('.image_browser_images_<?php echo $bwg; ?>').width();
                        if (bwg_image_browser_width <= 108) {
                          jQuery('.paging-input_<?php echo $bwg; ?>').css('display', 'none');
                        }
                        else if (bwg_image_browser_width <= 200) {
                          jQuery('.paging-input_<?php echo $bwg; ?>').css('margin', '0% 0% 0% 0%');
                          jQuery('.paging-input_<?php echo $bwg; ?>').css('display', 'inline');
                          jQuery('.tablenav-pages_<?php echo $bwg; ?> .next-page').css('margin', '0% 0% 0% 0%');
                          jQuery('.tablenav-pages_<?php echo $bwg; ?> .prev-page').css('margin', '0% 0% 0% 0%');
                        }
                        else if (bwg_image_browser_width <= 580) {
                          jQuery('.paging-input_<?php echo $bwg; ?>').css('display', 'inline');
                          jQuery('.tablenav-pages_<?php echo $bwg; ?> a').css('font-size', '13px');
                          jQuery('.paging-input_<?php echo $bwg; ?>').css('margin', '0% 7% 0% 7%');
                          jQuery('.tablenav-pages_<?php echo $bwg; ?> .next-page').css('margin', '0% 0% 0% 0%');
                          jQuery('.tablenav-pages_<?php echo $bwg; ?> .prev-page').css('margin', '0% 0% 0% 0%');
                        }
                        else {
                          jQuery('.tablenav-pages_<?php echo $bwg; ?> a').css('font-size', '15px');
                          jQuery('.paging-input_<?php echo $bwg; ?>').css('margin', '0%  14% 0%  14%');
                          jQuery('.paging-input_<?php echo $bwg; ?>').css('display', 'inline');
                          jQuery('.tablenav-pages_<?php echo $bwg; ?> .next-page').css('margin', '0% 0% 0% 0%');
                          jQuery('.tablenav-pages_<?php echo $bwg; ?> .prev-page').css('margin', '0% 0% 0% 0%');
                        }
                      }
                      setTimeout(function() {
                        bwg_image_browser_<?php echo $bwg; ?>();
                      }, 3);
                      </script>
                    </div>
                      <?php
                      if ($image_title && ($image_browser_image_title_align == 'bottom')) {
                        ?>
                         <div class="bwg_image_browser_image_alt_<?php echo $bwg; ?>">
                           <div class="bwg_image_alt_<?php echo $bwg; ?>" id="alt<?php echo $image_row->id; ?>">
                             <?php echo html_entity_decode($image_row->alt); ?>
                           </div>
                         </div> 
                        <?php
                      }
                      if ($enable_image_description && ($image_row->description != "")) {
                        ?>
                      <div class="bwg_image_browser_image_desp_<?php echo $bwg; ?>">                    
                        <div class="bwg_image_browser_image_description_<?php echo $bwg; ?>" id="alt<?php echo $image_row->id; ?>">
                          <?php echo html_entity_decode($image_row->description); ?>
                        </div>                  
                      </div>
                        <?php
                      }
                      ?>
                  </div>
                </div>
                <?php
              }
              if ( BWG()->is_pro && $gallery_download && $image_rows ) {
                $query_url = addslashes(add_query_arg(array(
                                                        "action" => "download_gallery",
                                                        "gallery_id" => $params['gallery_id'],
                                                        "bwg" => $bwg,
                                                        "type" => 'gallery',
                                                        "bwg_search_".$bwg => WDWLibrary::get('bwg_search_'.$bwg),
                                                      ), admin_url('admin-ajax.php')));
                ?>
                <div class="bwg_download_gallery">
                  <a href="<?php echo $query_url; ?>">
                    <i title="<?php _e('Download gallery', BWG()->prefix); ?>" class="bwg_ctrl_btn fa fa-download"></i>
                  </a>
                </div>
                <?php
              }
              if ( $theme_row->page_nav_position == 'bottom') {
                WDWLibrary::ajax_html_frontend_page_nav($theme_row, $page_nav['total'], $page_nav['limit'], 'gal_front_form_' . $bwg, $items_per_page, $bwg, 'bwg_image_browser_' . $bwg, 0, 'album', BWG()->options->enable_seo);
              }
              ?>
            </div>
          </div>
        </form>
        <div id="bwg_spider_popup_loading_<?php echo $bwg; ?>" class="bwg_spider_popup_loading"></div>
        <div id="spider_popup_overlay_<?php echo $bwg; ?>" class="spider_popup_overlay" onclick="spider_destroypopup(1000)"></div>
      </div>
    </div>
    <script>
      jQuery(window).on("load", function () {
        <?php if ($image_right_click) { ?>
          /* Disable right click.*/
          jQuery('div[id^="bwg_container"]').bind("contextmenu", function (e) {
            return false;
          });
          jQuery('div[id^="bwg_container"]').css('webkitTouchCallout','none');
		<?php } ?>
      });
      jQuery(window).resize(function() {
        bwg_image_browser_<?php echo $bwg; ?>();
      });
      function bwg_gallery_box_<?php echo $bwg; ?>(image_id) {
        var filtersearchname = jQuery("#bwg_search_input_<?php echo $bwg; ?>" ).val() ? "&filter_search_name_<?php echo $bwg; ?>=" + jQuery("#bwg_search_input_<?php echo $bwg; ?>" ).val() : '';
        spider_createpopup('<?php echo addslashes(add_query_arg($params_array, admin_url('admin-ajax.php'))); ?>&image_id=' + image_id + filtersearchname, '<?php echo $bwg; ?>', '<?php echo $params['popup_width']; ?>', '<?php echo $params['popup_height']; ?>', 1, 'testpopup', 5, "<?php echo $theme_row->lightbox_ctrl_btn_pos ;?>");
      }
      function bwg_document_ready_<?php echo $bwg; ?>() {
        var bwg_touch_flag = false;
        jQuery(".bwg_lightbox_<?php echo $bwg; ?>").on("click", function () {
          if (!bwg_touch_flag) {
            bwg_touch_flag = true;
            setTimeout(function(){ bwg_touch_flag = false; }, 100);
            bwg_gallery_box_<?php echo $bwg; ?>(jQuery(this).attr("data-image-id"));
            return false;
          }
        });
        <?php
        if ( BWG()->is_pro ) {
        ?>
        var bwg_hash = window.location.hash.substring(1);
        if (bwg_hash) {
          if (bwg_hash.indexOf("bwg") != "-1") {
            bwg_hash_array = bwg_hash.replace("bwg", "").split("/");
            if (bwg_hash_array[0] == "<?php echo $params_array['gallery_id']; ?>") {
              bwg_gallery_box_<?php echo $bwg; ?>(bwg_hash_array[1]);
            }
          }
        }
        <?php
        }
        ?>
      }
      jQuery(document).ready(function () {
        bwg_document_ready_<?php echo $bwg; ?>();
      });
    </script>
    <?php
    if ($from_shortcode) {
      return;
    }
    else {
      die();
    }
  }

  private function inline_styles($bwg, $theme_row, $params, $params_array, $text_align, $vertical_align) {
    ob_start();
    $rgb_page_nav_font_color = WDWLibrary::spider_hex2rgb($theme_row->page_nav_font_color);
    $image_browser_images_conteiner = WDWLibrary::spider_hex2rgb($theme_row->image_browser_full_bg_color);
    $bwg_image_browser_image = WDWLibrary::spider_hex2rgb($theme_row->image_browser_bg_color);
    ?>
      #bwg_container1_<?php echo $bwg; ?> #bwg_container2_<?php echo $bwg; ?> .image_browser_images_conteiner_<?php echo $bwg; ?> * {
        -moz-box-sizing: border-box;
        box-sizing: border-box;
      }
      #bwg_container1_<?php echo $bwg; ?> #bwg_container2_<?php echo $bwg; ?> .image_browser_images_conteiner_<?php echo $bwg; ?>{
				background-color: rgba(<?php echo $image_browser_images_conteiner['red']; ?>, <?php echo $image_browser_images_conteiner['green']; ?>, <?php echo $image_browser_images_conteiner['blue']; ?>, <?php echo number_format($theme_row->image_browser_full_transparent / 100, 2, ".", ""); ?>);
				text-align: center;
				width: 100%;
				border-style: <?php echo $theme_row->image_browser_full_border_style;?>;
				border-width: <?php echo $theme_row->image_browser_full_border_width;?>px;
				border-color: #<?php echo $theme_row->image_browser_full_border_color;?>;
				padding: <?php echo $theme_row->image_browser_full_padding; ?>;
				border-radius: <?php echo $theme_row->image_browser_full_border_radius; ?>;
				position:relative;
      }
      #bwg_container1_<?php echo $bwg; ?> #bwg_container2_<?php echo $bwg; ?> .image_browser_images_<?php echo $bwg; ?> {
				display: inline-block;
				-moz-box-sizing: border-box;
				box-sizing: border-box;
				font-size: 0;
				text-align: center;
				max-width: 100%;
				width: <?php echo $params['image_browser_width']; ?>px;
      }
      #bwg_container1_<?php echo $bwg; ?> #bwg_container2_<?php echo $bwg; ?> .image_browser_image_buttons_conteiner_<?php echo $bwg; ?> {
				text-align: <?php echo $theme_row->image_browser_align; ?>;
      }
      #bwg_container1_<?php echo $bwg; ?> #bwg_container2_<?php echo $bwg; ?> .image_browser_image_buttons_<?php echo $bwg; ?> {
				display: inline-block;
				width:100%;
      }
      #bwg_container1_<?php echo $bwg; ?> #bwg_container2_<?php echo $bwg; ?> .bwg_image_browser_image_<?php echo $bwg; ?> {
        background-color: rgba(<?php echo $bwg_image_browser_image['red']; ?>, <?php echo $bwg_image_browser_image['green']; ?>, <?php echo $bwg_image_browser_image['blue']; ?>, <?php echo number_format($theme_row->image_browser_transparent / 100, 2, ".", ""); ?>);
				text-align: center;
				/*display: inline-block;*/
				vertical-align: middle;
				margin: <?php echo $theme_row->image_browser_margin; ?>;
				padding: <?php echo $theme_row->image_browser_padding; ?>;
				border-radius: <?php echo $theme_row->image_browser_border_radius; ?>;
				border: <?php echo $theme_row->image_browser_border_width; ?>px <?php echo $theme_row->image_browser_border_style; ?> #<?php echo $theme_row->image_browser_border_color; ?>;
				box-shadow: <?php echo $theme_row->image_browser_box_shadow; ?>;
				/*z-index: 100;*/
				position: relative;
      }
      #bwg_container1_<?php echo $bwg; ?> #bwg_container2_<?php echo $bwg; ?> .bwg_image_alt_<?php echo $bwg; ?>{
				display: table;
				width: 100%;
				font-size: <?php echo $theme_row->image_browser_img_font_size; ?>px;
				font-family: <?php echo $theme_row->image_browser_img_font_family; ?>;
				color: #<?php echo $theme_row->image_browser_img_font_color; ?>;
				text-align:<?php echo $theme_row->image_browser_image_description_align; ?>;
				padding-left: 8px;
        word-break: break-word;
      }
      #bwg_container1_<?php echo $bwg; ?> #bwg_container2_<?php echo $bwg; ?> .bwg_image_browser_img_<?php echo $bwg; ?> {
        padding: 0 !important;
				max-width: 100% !important;
				height: inherit !important;
				width: 100%;				
      }
      @media only screen and (max-width : 320px) {
				#bwg_container1_<?php echo $bwg; ?> #bwg_container2_<?php echo $bwg; ?> .displaying-num_<?php echo $bwg; ?> {
				  display: none;
				}
				#bwg_container1_<?php echo $bwg; ?> #bwg_container2_<?php echo $bwg; ?> .bwg_image_alt_<?php echo $bwg; ?> {
				  font-size: 10px !important;
				}
				#bwg_container1_<?php echo $bwg; ?> #bwg_container2_<?php echo $bwg; ?> .bwg_watermark_text_<?php echo $bwg; ?>,
				#bwg_container1_<?php echo $bwg; ?> #bwg_container2_<?php echo $bwg; ?> .bwg_watermark_text_<?php echo $bwg; ?>:hover {
				  font-size: 10px !important;
				  text-decoration: none;
				  margin: 4px;
				  font-family: <?php echo $params_array['watermark_font']; ?>;
				  color: #<?php echo $params_array['watermark_color']; ?> !important;
				  opacity: <?php echo number_format($params_array['watermark_opacity'] / 100, 2, ".", ""); ?>;
			  	filter: Alpha(opacity=<?php echo $params_array['watermark_opacity']; ?>);
          text-decoration: none;
				  position: relative;
				  z-index: 10141;
				}
				#bwg_container1_<?php echo $bwg; ?> #bwg_container2_<?php echo $bwg; ?> .bwg_image_browser_image_description_<?php echo $bwg; ?> {
          color: #<?php echo $theme_row->image_browser_img_font_color; ?>;
				  display: table;
				  width: 100%;
				  text-align: left;
				  font-size: 8px !important;
				  font-family: <?php echo $theme_row->image_browser_img_font_family; ?>;
				  padding: <?php echo $theme_row->image_browser_image_description_padding; ?>;
				  /*word-break: break-all;*/
				  border-style: <?php echo $theme_row->image_browser_image_description_border_style; ?>;
				  background-color: #<?php echo $theme_row->image_browser_image_description_bg_color; ?>;
				  border-radius: <?php echo $theme_row->image_browser_image_description_border_radius; ?>;
				  border-width: <?php echo $theme_row->image_browser_image_description_border_width; ?>px;
				}
        
				#bwg_container1_<?php echo $bwg; ?> #bwg_container2_<?php echo $bwg; ?> .tablenav-pages_<?php echo $bwg; ?> a {
				  font-size: 10px !important;
				}				
      }
      /*pagination styles*/
      #bwg_container1_<?php echo $bwg; ?> #bwg_container2_<?php echo $bwg; ?> .tablenav-pages_<?php echo $bwg; ?> {
				text-align: <?php echo $theme_row->page_nav_align; ?>;
				font-size: <?php echo $theme_row->page_nav_font_size; ?>px;
				font-family: <?php echo $theme_row->page_nav_font_style; ?>;
				font-weight: <?php echo $theme_row->page_nav_font_weight; ?>;
				color: #<?php echo $theme_row->page_nav_font_color; ?>;
				margin: 6px 0 4px;
				display: block;
				height: 30px;
				line-height: 30px;
      }
      #bwg_container1_<?php echo $bwg; ?> #bwg_container2_<?php echo $bwg; ?> .displaying-num_<?php echo $bwg; ?> {
				font-size: <?php echo $theme_row->page_nav_font_size; ?>px;
				font-family: <?php echo $theme_row->page_nav_font_style; ?>;
				font-weight: <?php echo $theme_row->page_nav_font_weight; ?>;
				color: #<?php echo $theme_row->page_nav_font_color; ?>;
				margin-right: 10px;
				vertical-align: middle;
				display: none;
      }
      #bwg_container1_<?php echo $bwg; ?> #bwg_container2_<?php echo $bwg; ?> .paging-input_<?php echo $bwg; ?> {
				font-size: <?php echo $theme_row->page_nav_font_size; ?>px;
				font-family: <?php echo $theme_row->page_nav_font_style; ?>;
				font-weight: <?php echo $theme_row->page_nav_font_weight; ?>;
				color: #<?php echo $theme_row->page_nav_font_color; ?>;
				vertical-align: middle;
      }
      #bwg_container1_<?php echo $bwg; ?> #bwg_container2_<?php echo $bwg; ?> .tablenav-pages_<?php echo $bwg; ?> a.disabled,
      #bwg_container1_<?php echo $bwg; ?> #bwg_container2_<?php echo $bwg; ?> .tablenav-pages_<?php echo $bwg; ?> a.disabled:hover,
      #bwg_container1_<?php echo $bwg; ?> #bwg_container2_<?php echo $bwg; ?> .tablenav-pages_<?php echo $bwg; ?> a.disabled:focus {
				cursor: default;
				color: rgba(<?php echo $rgb_page_nav_font_color['red']; ?>, <?php echo $rgb_page_nav_font_color['green']; ?>, <?php echo $rgb_page_nav_font_color['blue']; ?>, 0.5);
      }
      #bwg_container1_<?php echo $bwg; ?> #bwg_container2_<?php echo $bwg; ?> .tablenav-pages_<?php echo $bwg; ?> a.next-page:hover,
      #bwg_container1_<?php echo $bwg; ?> #bwg_container2_<?php echo $bwg; ?> .tablenav-pages_<?php echo $bwg; ?> a.prev-page:hover {
        color: #000000;
      }
      #bwg_container1_<?php echo $bwg; ?> #bwg_container2_<?php echo $bwg; ?> .tablenav-pages_<?php echo $bwg; ?> a {
				cursor: pointer;
				font-size: 15px;
				font-family: <?php echo $theme_row->page_nav_font_style; ?>;
				font-weight: <?php echo $theme_row->page_nav_font_weight; ?>;
				color: #<?php echo $theme_row->page_nav_font_color; ?>;
				text-decoration: none;
				padding: 0% 7%;
				margin: <?php echo $theme_row->page_nav_margin; ?>;
				border-radius: <?php echo $theme_row->page_nav_border_radius; ?>;
				border-style: none;
				border-width: <?php echo $theme_row->page_nav_border_width; ?>px;
				border-color: #<?php echo $theme_row->page_nav_border_color; ?>;
				background-color: #<?php echo $theme_row->page_nav_button_bg_color; ?>;
				opacity: <?php echo number_format($theme_row->page_nav_button_bg_transparent / 100, 2, ".", ""); ?>;
				filter: Alpha(opacity=<?php echo $theme_row->page_nav_button_bg_transparent; ?>);
				<?php echo ($theme_row->page_nav_button_transition ) ? 'transition: all 0.3s ease 0s;-webkit-transition: all 0.3s ease 0s;' : ''; ?>
      }
      #bwg_container1_<?php echo $bwg; ?> #bwg_container2_<?php echo $bwg; ?> .tablenav-pages_<?php echo $bwg; ?> .first-page,
      #bwg_container1_<?php echo $bwg; ?> #bwg_container2_<?php echo $bwg; ?> .tablenav-pages_<?php echo $bwg; ?> .last-page {
        padding: 0% 7%; 		        
      }
	    #bwg_container1_<?php echo $bwg; ?> #bwg_container2_<?php echo $bwg; ?> .tablenav-pages_<?php echo $bwg; ?> .next-page {
        margin: 0% 4% 0% 0%; 		        
      }
      #bwg_container1_<?php echo $bwg; ?> #bwg_container2_<?php echo $bwg; ?> .tablenav-pages_<?php echo $bwg; ?> .prev-page {
        margin: 0% 0% 0% 4%; 		        
      }
      #bwg_container1_<?php echo $bwg; ?> #bwg_container2_<?php echo $bwg; ?> #spider_popup_overlay_<?php echo $bwg; ?> {
				background-color: #<?php echo $theme_row->lightbox_overlay_bg_color; ?>;
        opacity: <?php echo number_format($theme_row->lightbox_overlay_bg_transparent / 100, 2, ".", ""); ?>;
        filter: Alpha(opacity=<?php echo $theme_row->lightbox_overlay_bg_transparent; ?>);
      }
      #bwg_container1_<?php echo $bwg; ?> #bwg_container2_<?php echo $bwg; ?> .bwg_image_browser_image_desp_<?php echo $bwg; ?> {
				display: table;
				clear: both;
				text-align: center;
        padding: <?php echo $theme_row->image_browser_image_description_margin; ?>;
				width: 100%;
      }
      #bwg_container1_<?php echo $bwg; ?> #bwg_container2_<?php echo $bwg; ?> .bwg_image_browser_image_description_<?php echo $bwg; ?> {
        color: #<?php echo $theme_row->image_browser_img_font_color; ?>;
				display: table;
				width: 100%;
				text-align: left;
				font-size: <?php echo $theme_row->image_browser_img_font_size; ?>px;
				font-family: <?php echo$theme_row->image_browser_img_font_family; ?>;
				padding: <?php echo $theme_row->image_browser_image_description_padding; ?>;
				word-break: break-word;
				border-style: <?php echo $theme_row->image_browser_image_description_border_style; ?>;
				background-color: #<?php echo $theme_row->image_browser_image_description_bg_color; ?>;
				border-radius: <?php echo $theme_row->image_browser_image_description_border_radius; ?>;
				border-width: <?php echo $theme_row->image_browser_image_description_border_width; ?>px;
      }
      #bwg_container1_<?php echo $bwg; ?> #bwg_container2_<?php echo $bwg; ?> .bwg_image_browser_image_alt_<?php echo $bwg; ?> {
      	display:table;
        clear: both;
        text-align: center;
        padding: 8px;
        width: 100%;
      }
      /*watermark*/
      #bwg_container1_<?php echo $bwg; ?> #bwg_container2_<?php echo $bwg; ?> .bwg_watermark_text_<?php echo $bwg; ?>,
      #bwg_container1_<?php echo $bwg; ?> #bwg_container2_<?php echo $bwg; ?> .bwg_watermark_text_<?php echo $bwg; ?>:hover {
				text-decoration: none;
				margin: 4px;
				font-size: <?php echo $params_array['watermark_font_size']; ?>px;
				font-family: <?php echo $params_array['watermark_font']; ?>;
				color: #<?php echo $params_array['watermark_color']; ?> !important;
				opacity: <?php echo number_format($params_array['watermark_opacity'] / 100, 2, ".", ""); ?>;
				filter: Alpha(opacity=<?php echo $params_array['watermark_opacity']; ?>);
				position: relative;
				z-index: 10141;
      }
      #bwg_container1_<?php echo $bwg; ?> #bwg_container2_<?php echo $bwg; ?> .bwg_image_browser_image_contain_<?php echo $bwg; ?>{
				position: absolute;
				text-align: center;
				vertical-align: middle;
				width: 100%;
				height: 100%;
				cursor: pointer;
      }
      #bwg_container1_<?php echo $bwg; ?> #bwg_container2_<?php echo $bwg; ?> .bwg_image_browser_watermark_contain_<?php echo $bwg; ?>{
        display: table;
				vertical-align: middle;
				width: 100%;
				height: 100%;
      }	 
      #bwg_container1_<?php echo $bwg; ?> #bwg_container2_<?php echo $bwg; ?> .bwg_image_browser_watermark_cont_<?php echo $bwg; ?>{
        display: table-cell;
				text-align: <?php echo $text_align; ?>;
				position: relative;
				vertical-align: <?php echo $vertical_align; ?>;
      }
      #bwg_container1_<?php echo $bwg; ?> #bwg_container2_<?php echo $bwg; ?> .bwg_image_browser_watermark_<?php echo $bwg; ?>{
				display: inline-block;
				overflow: hidden;
				position: relative;
				vertical-align: middle;
				z-index: 10140;
				width: <?php echo $params_array['watermark_width'];?>px;
				max-width: <?php echo (($params_array['watermark_width']) / ($params['image_browser_width'])) * 100 ; ?>%;
				margin: 10px 10px 10px 10px ;
      }
      #bwg_container1_<?php echo $bwg; ?> #bwg_container2_<?php echo $bwg; ?> .bwg_image_browser_watermark_text_<?php echo $bwg; ?>{
        display: inline-block;
				overflow: hidden;
				position: relative;
				vertical-align: middle;
				z-index: 10140;
				margin: 10px 10px 10px 10px ;
      }
      #bwg_container1_<?php echo $bwg; ?> #bwg_container2_<?php echo $bwg; ?> .bwg_image_browser_watermark_img_<?php echo $bwg; ?>{
				max-width: 100%;
				opacity: <?php echo number_format($params_array['watermark_opacity'] / 100, 2, ".", ""); ?>;
				filter: Alpha(opacity=<?php echo $params_array['watermark_opacity']; ?>);
				position: relative;
				z-index: 10141;
      }
      #bwg_container1_<?php echo $bwg; ?> #bwg_container2_<?php echo $bwg; ?> .bwg_none_selectable {
        -webkit-touch-callout: none;
        -webkit-user-select: none;
        -khtml-user-select: none;
        -moz-user-select: none;
        -ms-user-select: none;
        user-select: none;
       ecoration: none;
    }
    #bwg_container1_<?php echo $bwg; ?> #bwg_container2_<?php echo $bwg; ?> .bwg_gal_title_<?php echo $bwg; ?> {
      background-color: rgba(0, 0, 0, 0);
      color: #<?php echo $theme_row->image_browser_gal_title_font_color; ?>;
      display: block;
      font-family: <?php echo $theme_row->image_browser_gal_title_font_style; ?>;
      font-size: <?php echo $theme_row->image_browser_gal_title_font_size; ?>px;
      font-weight: <?php echo $theme_row->image_browser_gal_title_font_weight; ?>;
      padding: <?php echo $theme_row->image_browser_gal_title_margin; ?>;
      text-shadow: <?php echo $theme_row->image_browser_gal_title_shadow; ?>;
      text-align: <?php echo $theme_row->image_browser_gal_title_align; ?>;
    }
    <?php
    return ob_get_clean();
  }
}
