<?php
/**
 * The template for displaying the footer
 *
 * Contains the closing of the #content div and all content after.
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package decoupelaser
 */

?>

		</div><!-- #content -->

		<footer id="colophon" class="site-footer">
			<div class="container-fluid site">
				<div class="row contactez-nous">
					<div class="contact-nous-wrap clearfix">
						<div class="col-md-6 decoupe-laser-footer-nav-titre">
							<p>CONTACTEZ-NOUS</p>
							<p class = "details">SARL Découpe Laser<br/>Zi la Vallière Batiment 11<br/>06730 Saint André de la Roche<br/>T. 04 93 88 79 36<br/>decoupe-laser@orange.fr</p>
						</div>
						<div class="col-md-3 contactez-nous-button">
							<p><a href="<?php echo get_permalink(24); ?>">DEMANDE DE DEVIS</a></p>
						</div>
						<div class="col-md-3 contactez-nous-button">
							<p><a href="<?php echo get_permalink(24); ?>">VISITER NOS ATELIERS</a></p>
						</div>						
					</div>

				</div>
				<div class="row decoupe-laser">
					<div class="decoupe-laser-wrap clearfix">
						<div class="col-md-6 decoupe-laser-footer-nav-titre">
							<p>DECOUPE LASER</p>
							<nav class="footer-navigation">
			
								<button class="menu-toggle" aria-controls="footer-menu" aria-expanded="false"><?php esc_html_e( 'Footer Menu', 'decoupelaser' ); ?></button>
								<?php
								wp_nav_menu( array(
									'theme_location' => 'menu-2',
									'menu_class'        => 'footer-menu',
								) );
								?>
							</nav>
						</div>
						<div class="col-md-6 decoupe-laser-footer-social-titre">
							<p>SOCIAL</p>
							<p class = "social-details"><a href="#" target="_blank">Facebook</a></p>
							<p class = "social-details">&copy; <?php echo date('Y'); ?> Découpe Laser
								<span class="sep"> | </span>
								<?php
								/* translators: 1: Theme name, 2: Theme author. */
								printf( esc_html__( '%1$s %2$s.', 'decoupelaser' ), 'Réalisation', '<a target="_blank" href="http://dpi-design.fr">dpi-design.fr</a>' );
								?>
							</p>						
						</div>
					</div>
				</div>
			</div>

		</footer><!-- #colophon -->
	</div><!-- #page -->	
</div><!-- .page-wrapper -->

<?php wp_footer(); ?>

</body>
</html>
